/*
Exemple d'utilisation des fonctions du module ADC.
validé pour la famille 16f87Xa,
On utilise le canal 0,
connecter les tensions à convertir à RA0,
connecter une led ou une autre sortie à RB7.
RB7 se mettra à l'état haut (Vdd) quand la tension en RA0 sera supérieur à 1/2 Vdd.
*/
#include <pic/p16f877a.h>
#include <adc.h>
int main(void)
{
TRISAbits.TRISA0 = 1; // A0 comme entrée
TRISBbits.TRISB7 = 0; // B7 comme sortie
adc_init( FOSC_DIV_32, A1_R0); // Initialise le module ADC
adc_open(CHANNEL_0); // Ouvre le canal 029: ADC
while (1)
{
if (adc_read() > 512 )
	PORTBbits.RB7 = 1; // Allumer la led
else
	PORTBbits.RB7 = 0; // Éteindre la led
      }
}
